﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace TransponderUART_Test
{
    public partial class Form1 : Form
    {
        // Dieses Programm wurde unter Visual Basic Studio NET erstellt.
	    // Es soll Ihnen helfen, die Serielle Schnittstelle unter Windows zo öffnen
	    // und die Daten vom easyident-R an der Schnittstelle abzuholen und anzuzeigen. 
	    // 
        // Erstellt von André Hester /  mail@andre-hester.de / www.andre-hester.de
	    // FS Fertigungsservice 
	    // Josef Rohrmüller
	    // eMail: info@easyident.de
	    //  11.03.2010

        // Variablen und Verbindungsobjekt initilisieren
        public string rx_buffer ;
        public string tx_buffer;
        public string transponder_id;
        public MSCommLib.MSComm uart_conn = new MSCommLib.MSComm();

        public Form1()
        {
            InitializeComponent();
            uart_conn.CommPort = 1;                         // COM-Port auswählen
            uart_conn.Settings = "9600,n,8,1";              // Betriebsart einstellen
            try
            {
                uart_conn.PortOpen = true;                  // Versuchen den COM-Port zu öffnen
            }
            catch (Exception e)
            {
                MessageBox.Show(e.ToString());
            }
            uart_conn.RThreshold = 1;                       // Abholen von einzelnen Zeichen aktivieren
            uart_conn.DTREnable = true;                     // Data Terminal Signal auf high setzen
            uart_conn.RTSEnable = true;                     // Request to Send Signal auf high setzen
        }

        private void button1_Click(object sender, EventArgs e)
        {
            textBox1.Clear();                               // Textbox löschen
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            if (uart_conn.PortOpen == true)                 // Abfrage des Port-Status
            {
                int n;

                rx_buffer = rx_buffer + uart_conn.Input;
                if (rx_buffer.Length > 27)                  // Prüfen ob 2 Datensätze im Read-Buffer liegen
                {
                    n = rx_buffer.IndexOf("\r\n");          // Stelle Linefeed suchen
                    transponder_id = rx_buffer.Substring(n + 2, 11); // Zeichen nach dem Linefeed kopieren
                    textBox1.Text = transponder_id;         // Transponder ID in Textfeld schreiben
                }
                rx_buffer = "";                             // Read-Buffer leeren
            }
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            uart_conn.PortOpen = false;                     // COM-Port schließen
        }
    }
}
