Public Class Form1
    Inherits System.Windows.Forms.Form

#Region " Vom Windows Form Designer generierter Code "

    Public Sub New()
        MyBase.New()

        ' Dieser Aufruf ist fr den Windows Form-Designer erforderlich.
        InitializeComponent()

        ' Initialisierungen nach dem Aufruf InitializeComponent() hinzufgen

    End Sub

    ' Die Form berschreibt den Lschvorgang der Basisklasse, um Komponenten zu bereinigen.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    ' Fr Windows Form-Designer erforderlich
    Private components As System.ComponentModel.IContainer

    'HINWEIS: Die folgende Prozedur ist fr den Windows Form-Designer erforderlich
    'Sie kann mit dem Windows Form-Designer modifiziert werden.
    'Verwenden Sie nicht den Code-Editor zur Bearbeitung.
	Friend WithEvents AxMSComm1 As AxMSCommLib.AxMSComm
	Friend WithEvents TextBox1 As System.Windows.Forms.TextBox
	Friend WithEvents Button1 As System.Windows.Forms.Button
	Friend WithEvents MainMenu1 As System.Windows.Forms.MainMenu
	Friend WithEvents MenuItem1 As System.Windows.Forms.MenuItem
	Friend WithEvents MenuItem2 As System.Windows.Forms.MenuItem
	Friend WithEvents Timer1 As System.Timers.Timer
	Friend WithEvents Label1 As System.Windows.Forms.Label
	Friend WithEvents Label2 As System.Windows.Forms.Label
	Friend WithEvents TextBox2 As System.Windows.Forms.TextBox
	<System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
		Dim resources As System.Resources.ResourceManager = New System.Resources.ResourceManager(GetType(Form1))
		Me.AxMSComm1 = New AxMSCommLib.AxMSComm()
		Me.TextBox1 = New System.Windows.Forms.TextBox()
		Me.Button1 = New System.Windows.Forms.Button()
		Me.MainMenu1 = New System.Windows.Forms.MainMenu()
		Me.MenuItem1 = New System.Windows.Forms.MenuItem()
		Me.MenuItem2 = New System.Windows.Forms.MenuItem()
		Me.Timer1 = New System.Timers.Timer()
		Me.Label1 = New System.Windows.Forms.Label()
		Me.Label2 = New System.Windows.Forms.Label()
		Me.TextBox2 = New System.Windows.Forms.TextBox()
		CType(Me.AxMSComm1, System.ComponentModel.ISupportInitialize).BeginInit()
		CType(Me.Timer1, System.ComponentModel.ISupportInitialize).BeginInit()
		Me.SuspendLayout()
		'
		'AxMSComm1
		'
		Me.AxMSComm1.Enabled = True
		Me.AxMSComm1.Location = New System.Drawing.Point(624, 288)
		Me.AxMSComm1.Name = "AxMSComm1"
		Me.AxMSComm1.OcxState = CType(resources.GetObject("AxMSComm1.OcxState"), System.Windows.Forms.AxHost.State)
		Me.AxMSComm1.Size = New System.Drawing.Size(38, 38)
		Me.AxMSComm1.TabIndex = 0
		'
		'TextBox1
		'
		Me.TextBox1.BackColor = System.Drawing.Color.Aqua
		Me.TextBox1.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle
		Me.TextBox1.Cursor = System.Windows.Forms.Cursors.Default
		Me.TextBox1.Location = New System.Drawing.Point(160, 64)
		Me.TextBox1.Multiline = True
		Me.TextBox1.Name = "TextBox1"
		Me.TextBox1.Size = New System.Drawing.Size(88, 24)
		Me.TextBox1.TabIndex = 1
		Me.TextBox1.Text = "TextBox1"
		'
		'Button1
		'
		Me.Button1.Location = New System.Drawing.Point(272, 64)
		Me.Button1.Name = "Button1"
		Me.Button1.Size = New System.Drawing.Size(120, 24)
		Me.Button1.TabIndex = 2
		Me.Button1.Text = "Lschen"
		'
		'MainMenu1
		'
		Me.MainMenu1.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuItem1})
		'
		'MenuItem1
		'
		Me.MenuItem1.Index = 0
		Me.MenuItem1.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuItem2})
		Me.MenuItem1.RadioCheck = True
		Me.MenuItem1.Text = "Datei"
		'
		'MenuItem2
		'
		Me.MenuItem2.Index = 0
		Me.MenuItem2.Text = "Beenden"
		'
		'Timer1
		'
		Me.Timer1.Enabled = True
		Me.Timer1.SynchronizingObject = Me
		'
		'Label1
		'
		Me.Label1.Location = New System.Drawing.Point(64, 112)
		Me.Label1.Name = "Label1"
		Me.Label1.Size = New System.Drawing.Size(88, 24)
		Me.Label1.TabIndex = 3
		Me.Label1.Text = "Tr_ID_Nummer"
		'
		'Label2
		'
		Me.Label2.Location = New System.Drawing.Point(88, 72)
		Me.Label2.Name = "Label2"
		Me.Label2.Size = New System.Drawing.Size(64, 16)
		Me.Label2.TabIndex = 4
		Me.Label2.Text = "Text Box 1"
		'
		'TextBox2
		'
		Me.TextBox2.BackColor = System.Drawing.Color.FromArgb(CType(192, Byte), CType(192, Byte), CType(255, Byte))
		Me.TextBox2.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle
		Me.TextBox2.Location = New System.Drawing.Point(160, 104)
		Me.TextBox2.Name = "TextBox2"
		Me.TextBox2.Size = New System.Drawing.Size(88, 20)
		Me.TextBox2.TabIndex = 5
		Me.TextBox2.Text = "TextBox2"
		'
		'Form1
		'
		Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
		Me.BackColor = System.Drawing.Color.Silver
		Me.ClientSize = New System.Drawing.Size(440, 257)
		Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.TextBox2, Me.Label2, Me.Label1, Me.Button1, Me.TextBox1, Me.AxMSComm1})
		Me.Icon = CType(resources.GetObject("$this.Icon"), System.Drawing.Icon)
		Me.Menu = Me.MainMenu1
		Me.Name = "Form1"
		Me.Text = "  easyident-R Demosoftware"
		Me.TopMost = True
		Me.TransparencyKey = System.Drawing.Color.DarkGray
		CType(Me.AxMSComm1, System.ComponentModel.ISupportInitialize).EndInit()
		CType(Me.Timer1, System.ComponentModel.ISupportInitialize).EndInit()
		Me.ResumeLayout(False)

	End Sub

#End Region

	REM Dieses Programm wurde unter Visual Basic Studio NET erstellt.
	REM Es soll Ihnen helfen, die Serielle Schnittstelle unter Windows zo ffnen
	REM und die Daten vom easyident-R an der Schnittstelle abzuholen und anzuzeigen. 
	REM
	REM FS Fertigungsservice 
	REM Josef Rohrmller
	REM eMail: info@easyident.de
	REM 11.10.2004
	REM


	Public RxBuffer As String	 ' Receive Buffer fr RS232
	Public TxBuffer As String	 ' Transmit Buffer fr RS232
	Public Tr_ID_Nummer As String	' String_Buffer fr Transponder ID Nummer.

	REM ----------------- Com Schnittstelle offnen. -----------------------------------
	REM Diese Routine wird beim starten des Programms einmal durchlaufen.
	REM Sie ffnet die Com 1 Schnittstelle des Computers.                    

	Private Sub Main_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
		AxMSComm1.CommPort = 1		   ' COM-Port festlegen 1=COM1, 2=COM2 usw.
		AxMSComm1.Settings = "9600,n,8,1"		  ' Baud=9600, no Parity, 8 Databit, 1 Stopbit.
		AxMSComm1.PortOpen = True		' COM Port ffnen.
		If Err.Number <> 0 Then		 ' Fehler beim ffnen der RS232 Schnittstelle prfen. 
			MsgBox("Kann COM Schnittstelle nicht ffnen." & vbCrLf _
			& "Vermutlich wird diese COM-Schnittstelle" & vbCrLf _
			& "bereits von einem anderen Programm  benutzt.")
			Exit Sub
		End If
		AxMSComm1.RThreshold = 1		 ' Festlegen, das einzelne Zeichen abgeholt werden knnen. 
		AxMSComm1.DTREnable = True		 ' Data Terminal Signal auf high setzen.
		AxMSComm1.RTSEnable = True		 ' Request to Send Signal auf high setzen.

		RxBuffer = AxMSComm1.Input		 ' Com Port UART Buffer leeren.
		Timer1.Interval() = 500		  ' alle 500 mS Daten von der RS232 holen.
		Timer1.Start()			' Start Timer
	End Sub



	Private Sub TextBox1_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TextBox1.TextChanged

	End Sub

	Private Sub AxMSComm1_OnComm(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles AxMSComm1.OnComm

	End Sub

	Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
		TextBox1.Clear()		' Textbox1 lschen.

	End Sub

	Private Sub MenuItem2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuItem2.Click
		AxMSComm1.PortOpen = False	   ' COM Schnittstelle schlieen.
		Close()		 ' Programm beenden.
	End Sub

	REM Diese Routine wird all 500 ms mit dem Timer1 aufgerufen.
	REM Es werden dann die Daten von der RS232 Schnittstelle abgeholt.
	REM Es mssen min. 2 Datenstze im RxBuffer vorhanden sein.
	REM Nach dem ersten <LF> werden die nchsten 11 Zeichen (10 fr Tr-ID, 1 fr Chechsumme.
	REM in den Tr_ID-Nummer Buffer geschrieben und angezeigt.


	Private Sub Timer1_Elapsed(ByVal sender As System.Object, ByVal e As System.Timers.ElapsedEventArgs) Handles Timer1.Elapsed

		Static blen As Int16		' Anzahl der Zeichen im Rx_Buffer.
		Static n As Int16		 ' counter.

		RxBuffer = RxBuffer + AxMSComm1.Input		 ' Alle Zeichen von der RS232 Schnittstelle abholen
		blen = RxBuffer.Length		 ' Anzahl der Zeichen im RX_Buffer feststellen.
		TextBox2.Clear()
		If blen > 27 Then		' Es werden 2 Datenstze erwartet.
			For n = 1 To 15			' Line feed im RxBuffer  suchen.
				If Mid(RxBuffer, n, 1) = vbLf Then
					Exit For
				End If
			Next
			Tr_ID_Nummer = Mid$(RxBuffer, n + 1, 11)			 '11 Zeichen aus RxBuffer holen. 
			TextBox1.Text = Tr_ID_Nummer			  ' Tr_ID_Nummer anzeigen.
			TextBox2.Text = Tr_ID_Nummer
			RxBuffer = ""			 ' RxBuffer lschen.
		End If
		Timer1.Start()		 '  Timer1 neu starten. 
	End Sub

End Class
