# Programm easyidentReader.py  11.1.2015 Josef Rohrmüller FS Fertigungsservice

import serial
import time
import RPi.GPIO as GPIO

GPIO.setmode(GPIO.BCM)
GPIO.setwarnings (False)            # GPIO Warnmeldungen ausschalten.
GPIO.setup(18, GPIO.OUT)         # GPIO 18 für Relais Ausgang verwenden

# -----------------------------------------------------------------------------------------------------------------------------
# Tragen sie hier in die Liste die Transponder ein die berechtigt sind das Relais anzuziehen
# -----------------------------------------------------------------------------------------------------------------------------
Transponder = ["0F006F2E27",            # 1. Transponder
                           "0F0179688B",            # 2. Transponder
                           "01098B179C",            # 3. Transponder
                            "01098B00DD",           # 4. Transponder u.s.w
                            ]

ser=serial.Serial(                          # öffne Serielle Schnittstelle
    port="/dev/ttyAMA0",
    baudrate=19200,                              # 19200 Baud
    parity=serial.PARITY_NONE,            # No Parity
    stopbits=serial.STOPBITS_ONE ,      # 1 Stopbit
    bytesize=serial.EIGHTBITS )              # 8 Datenbits

print ("Aktuelles Datum Uhrzeit ->  ", time.asctime())

# -----------------------------------------------------------------------------------------------------------------------
# Schaltet das Relais EIN
# -----------------------------------------------------------------------------------------------------------------------  
def RelaisOn():                        # Function Relaiseinschalten
    GPIO.output(18,1)
    
# -----------------------------------------------------------------------------------------------------------------------
# Schaltet das Relais AUS
# -----------------------------------------------------------------------------------------------------------------------
def RelaisOff():                        # Function Relais ausschalten
    GPIO.output(18,0)           

# -----------------------------------------------------------------------------------------------------------------------
# Schaltet das Relais für eine Zeit x ein (float)
# -----------------------------------------------------------------------------------------------------------------------
def RelaisOnOff(Time):      # Function Relais bestimmte Zeit einschalten
    GPIO.output(18,1)           # Relais einschalten
    time.sleep(Time)             # Warte Zeit ab. (float)
    GPIO.output(18,0)           # Relais wieder ausschalten

# -----------------------------------------------------------------------------------------------------------------------
# Liest einen String von der Seriellen Schnittstelle ein, bis die LF Taste gedrückt wird.
# -----------------------------------------------------------------------------------------------------------------------
def ReadTransponder(ser):               # Fuunktion Transponder ID-Lesen
    MyString = ""                                   # MyString löschen
    while 1:                                            # Endlos Schleife bis ein Enter (0X0d) kommt
        if ser.inWaiting() > 0:                     # Prüfe ob Zeichen an RS232 vorhanden
            try:
                ch = ser.read(1)                    # 1 Zeichen von RS232 abholen, (ch) = ein Byte(Array)
                Help = chr(ch[0])                   #  Byte in String wandeln
                if (ch[0] ==  10):                      # Abfragen ob LineFeed Zeichen. (End of Line)
                    break                                   # Abbruch. While Schleife verlassen
                MyString = MyString + Help      # MyString mit Zeichen auffüllen
            except (KeyboardInterrupt):         # Keyboard (CTRL-C) Abbruch?
                break
    MyString = MyString[1:-2]           # Header , Checksumme und CR entfernen 
    return MyString                             # Transponder ID-Nummer zurückgeben.

#----------------------------------------------------------------------------------------------------------------------------
# Gibt einen String an der RS232 Schnittstelle aus
#----------------------------------------------------------------------------------------------------------------------------
def WriteLine(DString):                 # Funktion definieren
    My = bytes(DString,"utf-8")      # String in ein Byte(Array) wandeln
    ser.write(My)                             # Byte(Array) auf RS232 ausgeben.

#---------------------------------------------------------------------------------------------------------------------------
# Hauptprogramm
#---------------------------------------------------------------------------------------------------------------------------

ser.flushOutput()                                           # Serial Output Buffer löschen
ser.flushInput()                                              # Serial Input Buffer löschen

while True:                                                   # Endlos Schleife
    MyString = ReadTransponder(ser)        # Liest Transponder Daten
    Login = False
    for n in range(len(Transponder)):           # Transponder Anzahl ermitteln
        if MyString == Transponder[n]:           #
            print("Eingeloggt mit Transponder ->  ", MyString, "   ", time.asctime())   # Ausgabe auf Monitor
            RelaisOnOff(1.5)                                # Relais 1,5 Sekund anziehen.
            Login = True
            
    if Login == False:                              # Transponder nicht in der Liste!
        print("Transponder nicht berechtigt  ->  ", MyString, "   " ,time.asctime())

    
    











